﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private rand As New Random()
    Private numTaps As Integer = 0


    Public Sub New()
        InitializeComponent()
        UpdatePageTitle(numTaps)
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        ContentPanel.Background = New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(256)),
                                                                          CByte(rand.Next(256)),
                                                                          CByte(rand.Next(256))))
        numTaps += 1
        UpdatePageTitle(numTaps)

        args.Complete()
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub UpdatePageTitle(ByVal numTaps As Integer)
        PageTitle.Text = String.Format("{0} taps total", numTaps)
    End Sub
End Class
